Ext.data.JsonP.sol_common_as_functions_OfficeConverter({"tagname":"class","name":"sol.common.as.functions.OfficeConverter","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.Office.js","href":"lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter"}],"author":[{"tagname":"author","name":"MV, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloas":true,"requires":["sol.common.RepoUtils","sol.common.XmlUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.as.FunctionBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.as.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"saveFormats","tagname":"cfg","owner":"sol.common.as.functions.OfficeConverter","id":"cfg-saveFormats","meta":{"private":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"docClassNames","tagname":"property","owner":"sol.common.as.functions.OfficeConverter","id":"property-docClassNames","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.as.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"regions","tagname":"property","owner":"sol.common.as.functions.OfficeConverter","id":"property-regions","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addPart","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-addPart","meta":{"private":true}},{"name":"checkFormat","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-checkFormat","meta":{"private":true}},{"name":"copyFontProperties","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-copyFontProperties","meta":{"private":true}},{"name":"editParts","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-editParts","meta":{}},{"name":"execute","tagname":"method","owner":"sol.common.as.FunctionBase","id":"method-execute","meta":{}},{"name":"fillContentControls","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-fillContentControls","meta":{"private":true}},{"name":"getCells","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getCells","meta":{}},{"name":"getPartSord","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getPartSord","meta":{"private":true}},{"name":"getSaveParams","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParams","meta":{"private":true}},{"name":"getSaveParamsCSV","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParamsCSV","meta":{"private":true}},{"name":"getSaveParamsDOCX","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParamsDOCX","meta":{"private":true}},{"name":"getSaveParamsHTML","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParamsHTML","meta":{"private":true}},{"name":"getSaveParamsPDF","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParamsPDF","meta":{"private":true}},{"name":"getSaveParamsXLSX","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getSaveParamsXLSX","meta":{"private":true}},{"name":"getTableData","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-getTableData","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-initialize","meta":{"private":true}},{"name":"isSupported","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-isSupported","meta":{"private":true}},{"name":"loadPartDocument","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-loadPartDocument","meta":{"private":true}},{"name":"mailMerge","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-mailMerge","meta":{"private":true}},{"name":"open","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-open","meta":{"private":true}},{"name":"openFile","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-openFile","meta":{"private":true}},{"name":"openFromRepo","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-openFromRepo","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-process","meta":{"abstract":true}},{"name":"save","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-save","meta":{"private":true}},{"name":"saveAsString","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-saveAsString","meta":{"private":true}},{"name":"saveFile","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-saveFile","meta":{"private":true}},{"name":"savePDF","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-savePDF","meta":{"private":true}},{"name":"saveToRepo","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-saveToRepo","meta":{"private":true}},{"name":"saveToStream","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-saveToStream","meta":{"private":true}},{"name":"updatePart","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-updatePart","meta":{"private":true}},{"name":"updateParts","tagname":"method","owner":"sol.common.as.functions.OfficeConverter","id":"method-updateParts","meta":{}}],"code_type":"ext_define","id":"class-sol.common.as.functions.OfficeConverter","short_doc":"Converts office documents into other formats like PDF or HTML\n\nUsage:\n\nvar officeConverter = sol.create(\"sol.common.a...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.as.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a><div class='subclass '><strong>sol.common.as.functions.OfficeConverter</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.XmlUtils' rel='sol.common.XmlUtils' class='docClass'>sol.common.XmlUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter' target='_blank'>lib_sol.common.as.Office.js</a></div></pre><div class='doc-contents'><p>Converts office documents into other formats like PDF or HTML</p>\n\n<h2>Usage:</h2>\n\n<pre><code>var officeConverter = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.as.functions.OfficeConverter\" rel=\"sol.common.as.functions.OfficeConverter\" class=\"docClass\">sol.common.as.functions.OfficeConverter</a>\", {\n  openFromRepo: {\n    objId: \"3630\"\n  },\n  saveToRepo: {\n    format: \"pdf\",\n    parentId: \"ARCPATH:/Test\",\n    name: \"Excel1\" }\n});\n</code></pre>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-saveFormats' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-cfg-saveFormats' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-cfg-saveFormats' class='name expandable'>saveFormats</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Supported destination formats ...</div><div class='long'><p>Supported destination formats</p>\n<p>Defaults to: <code>{pdf: {}}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-docClassNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-property-docClassNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-property-docClassNames' class='name expandable'>docClassNames</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Supported extensions and the appropriate class name ...</div><div class='long'><p>Supported extensions and the appropriate class name</p>\n<p>Defaults to: <code>{doc: &quot;sol.common.as.WordDocument&quot;, docx: &quot;sol.common.as.WordDocument&quot;, rtf: &quot;sol.common.as.WordDocument&quot;, odt: &quot;sol.common.as.WordDocument&quot;, xls: &quot;sol.common.as.ExcelDocument&quot;, xlsx: &quot;sol.common.as.ExcelDocument&quot;, xlsm: &quot;sol.common.as.ExcelDocument&quot;, xltx: &quot;sol.common.as.ExcelDocument&quot;, xltm: &quot;sol.common.as.ExcelDocument&quot;, csv: &quot;sol.common.as.ExcelDocument&quot;, ods: &quot;sol.common.as.ExcelDocument&quot;, ppt: &quot;sol.common.as.PowerPointDocument&quot;, pot: &quot;sol.common.as.PowerPointDocument&quot;, pps: &quot;sol.common.as.PowerPointDocument&quot;, pptx: &quot;sol.common.as.PowerPointDocument&quot;, potx: &quot;sol.common.as.PowerPointDocument&quot;, pptm: &quot;sol.common.as.PowerPointDocument&quot;, odp: &quot;sol.common.as.PowerPointDocument&quot;, msg: &quot;sol.common.as.MapiMessage&quot;, vsd: &quot;sol.common.as.VisioDocument&quot;, vss: &quot;sol.common.as.VisioDocument&quot;, vst: &quot;sol.common.as.VisioDocument&quot;, vsx: &quot;sol.common.as.VisioDocument&quot;, vdw: &quot;sol.common.as.VisioDocument&quot;, vdx: &quot;sol.common.as.VisioDocument&quot;, vsdx: &quot;sol.common.as.VisioDocument&quot;}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-regions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-property-regions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-property-regions' class='name expandable'>regions</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addPart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-addPart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-addPart' class='name expandable'>addPart</a>( <span class='pre'>searchPartIdFieldName, bodyNode, insertAfterNode, partId, partIdentifier</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds a single Word part ...</div><div class='long'><p>Adds a single Word part</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchPartIdFieldName</span> : String<div class='sub-desc'><p>Part ID search field name</p>\n</div></li><li><span class='pre'>bodyNode</span> : com.aspose.words.Node<div class='sub-desc'>\n</div></li><li><span class='pre'>insertAfterNode</span> : com.aspose.words.Node<div class='sub-desc'>\n</div></li><li><span class='pre'>partId</span> : String<div class='sub-desc'><p>Part ID</p>\n</div></li><li><span class='pre'>partIdentifier</span> : String<div class='sub-desc'><p>Part identifier</p>\n</div></li></ul></div></div></div><div id='method-checkFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-checkFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-checkFormat' class='name expandable'>checkFormat</a>( <span class='pre'>saveConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks whether the destination format is supported. ...</div><div class='long'><p>Checks whether the destination format is supported.</p>\n\n<pre><code>var result = officeDocument.checkFormat({ \"format\": \"pdf\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>UnsupportedException</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-copyFontProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-copyFontProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-copyFontProperties' class='name expandable'>copyFontProperties</a>( <span class='pre'>srcFont, dstFont</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Copies font properties ...</div><div class='long'><p>Copies font properties</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcFont</span> : com.aspose.words.Font<div class='sub-desc'><p>Source font</p>\n</div></li><li><span class='pre'>dstFont</span> : com.aspose.words.Font<div class='sub-desc'><p>Source font</p>\n</div></li></ul></div></div></div><div id='method-editParts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-editParts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-editParts' class='name expandable'>editParts</a>( <span class='pre'>partIds, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Edits Word document parts ...</div><div class='long'><p>Edits Word document parts</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>partIds</span> : Array<div class='sub-desc'><p>Part IDs</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>searchPartIdFieldName</span> : String (optional)<div class='sub-desc'><p>Part ID search field name</p>\n<p>Defaults to: <code>DOCUMENT_PART_ID</code></p></div></li><li><span class='pre'>partIdentifierPrefix</span> : String (optional)<div class='sub-desc'><p>Part identifier prefix</p>\n<p>Defaults to: <code>sol.common.DocumentPart</code></p></div></li></ul></div></li></ul></div></div></div><div id='method-execute' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Execution of the function module ...</div><div class='long'><p>Execution of the function module</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fillContentControls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-fillContentControls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-fillContentControls' class='name expandable'>fillContentControls</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Renders a template word document with content controls. ...</div><div class='long'><p>Renders a template word document with content controls.\nThe placeholders must be defined in 'mustache' syntax.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>JavaScript object that contains the data to fill-in</p>\n\n<p>The tag of the content control must contain a Handlesbars string which determinates what should be filled in.\ne.g. {{{CONTRACT.objKeys.PARTNER_NAME}}}</p>\n</div></li></ul></div></div></div><div id='method-getCells' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getCells' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getCells' class='name expandable'>getCells</a>( <span class='pre'>sheetIndex</span> ) : com.aspose.cells.Cells<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the excel cells ...</div><div class='long'><p>Returns the excel cells</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sheetIndex</span> : <div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.aspose.cells.Cells</span><div class='sub-desc'><p>Cells</p>\n</div></li></ul></div></div></div><div id='method-getPartSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getPartSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getPartSord' class='name expandable'>getPartSord</a>( <span class='pre'>searchPartIdFieldName, partId</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Get part sord ...</div><div class='long'><p>Get part sord</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>searchPartIdFieldName</span> : Object<div class='sub-desc'><p>Part ID search field name</p>\n</div></li><li><span class='pre'>partId</span> : String<div class='sub-desc'><p>Part ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParams' class='name expandable'>getSaveParams</a>( <span class='pre'>saveConfig</span> ) : Function<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Function</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParamsCSV' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParamsCSV' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParamsCSV' class='name expandable'>getSaveParamsCSV</a>( <span class='pre'></span> ) : Packages.com.aspose.cells.TxtSaveOptions<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Packages.com.aspose.cells.TxtSaveOptions</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParamsDOCX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParamsDOCX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParamsDOCX' class='name expandable'>getSaveParamsDOCX</a>( <span class='pre'></span> ) : com.aspose.words.SaveOptions<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.aspose.words.SaveOptions</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParamsHTML' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParamsHTML' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParamsHTML' class='name expandable'>getSaveParamsHTML</a>( <span class='pre'></span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParamsPDF' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParamsPDF' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParamsPDF' class='name expandable'>getSaveParamsPDF</a>( <span class='pre'></span> ) : com.aspose.diagram.DiagramSaveOptions<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>com.aspose.diagram.DiagramSaveOptions</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSaveParamsXLSX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getSaveParamsXLSX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getSaveParamsXLSX' class='name expandable'>getSaveParamsXLSX</a>( <span class='pre'></span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTableData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-getTableData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-getTableData' class='name expandable'>getTableData</a>( <span class='pre'>params, columns, Table</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns table data ...</div><div class='long'><p>Returns table data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>sheetIndex</span> : Number (optional)<div class='sub-desc'>\n<p>Defaults to: <code>0</code></p></div></li><li><span class='pre'>startRowIndex</span> : String (optional)<div class='sub-desc'><p>Start row index</p>\n<p>Defaults to: <code>0</code></p></div></li><li><span class='pre'>startColumnIndex</span> : String (optional)<div class='sub-desc'><p>Start row index</p>\n<p>Defaults to: <code>0</code></p></div></li></ul></div></li><li><span class='pre'>columns</span> : Object<div class='sub-desc'><p>Column names</p>\n<ul><li><span class='pre'>key</span> : Objekt<div class='sub-desc'><p>Column key</p>\n</div></li><li><span class='pre'>type</span> : Object<div class='sub-desc'><p>Colum type, e.g. 'String', 'Date'</p>\n</div></li></ul></div></li><li><span class='pre'>Table</span> : Object<div class='sub-desc'><p>data</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-initialize\" rel=\"sol.common.as.FunctionBase-method-initialize\" class=\"docClass\">sol.common.as.FunctionBase.initialize</a></p></div></div></div><div id='method-isSupported' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-isSupported' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-isSupported' class='name expandable'>isSupported</a>( <span class='pre'>extension</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks whether the extension is supported by the converter. ...</div><div class='long'><p>Checks whether the extension is supported by the converter.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>extension</span> : String<div class='sub-desc'><p>Extension of the source document.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the extension is supported</p>\n</div></li></ul></div></div></div><div id='method-loadPartDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-loadPartDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-loadPartDocument' class='name expandable'>loadPartDocument</a>( <span class='pre'>partObjId</span> ) : sol.common.as.WordDocument<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Loads a part document ...</div><div class='long'><p>Loads a part document</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>partObjId</span> : String<div class='sub-desc'><p>Part object ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>sol.common.as.WordDocument</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mailMerge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-mailMerge' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-mailMerge' class='name expandable'>mailMerge</a>( <span class='pre'>data, dataDefinition</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Renders a template word document with placeholders. ...</div><div class='long'><p>Renders a template word document with placeholders.\nThe placeholders must be defined in 'mustache' syntax.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>JavaScript object that contains the data to fill-in</p>\n</div></li><li><span class='pre'>dataDefinition</span> : Object<div class='sub-desc'><p>Data definition to resolve JavaScript arrays to XML tags</p>\n</div></li></ul></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-open' class='name expandable'>open</a>( <span class='pre'>inputStream</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>inputStream</span> : java.io.InputStream<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-openFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-openFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-openFile' class='name expandable'>openFile</a>( <span class='pre'>openFileConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Opens a source file. ...</div><div class='long'><p>Opens a source file.</p>\n\n<pre><code>officeDocument.openFile({ \"file\": \"d:/temp/file1.docx\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>openFileConfig</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-openFromRepo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-openFromRepo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-openFromRepo' class='name expandable'>openFromRepo</a>( <span class='pre'>openFromRepoConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Opens a document from the repository. ...</div><div class='long'><p>Opens a document from the repository.</p>\n\n<pre><code>officeDocument.openFromRepo({ objId: \"ARCPATH:/Folder1/Document1\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>openFromRepoConfig</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-process\" rel=\"sol.common.as.FunctionBase-method-process\" class=\"docClass\">sol.common.as.FunctionBase.process</a></p></div></div></div><div id='method-save' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-save' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-save' class='name expandable'>save</a>( <span class='pre'>outputStream, saveParams</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>outputStream</span> : java.io.OutputStream<div class='sub-desc'>\n</div></li><li><span class='pre'>saveParams</span> : com.aspose.diagram.DiagramSaveOptions<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-saveAsString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-saveAsString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-saveAsString' class='name expandable'>saveAsString</a>( <span class='pre'>saveConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Writes the converted document into a string. ...</div><div class='long'><p>Writes the converted document into a string. e.g. a CSV content.</p>\n\n<pre><code>officeDocument.saveAsString({ format: \"pdf\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Content</p>\n</div></li></ul></div></div></div><div id='method-saveFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-saveFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-saveFile' class='name expandable'>saveFile</a>( <span class='pre'>saveFileConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Saves the converted document to a file. ...</div><div class='long'><p>Saves the converted document to a file.</p>\n\n<pre><code>officeDocument.saveFile({ format: \"pdf\", filePath: \"c:\\\\Temp\\\\Document1.pdf\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveFileConfig</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-savePDF' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-savePDF' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-savePDF' class='name expandable'>savePDF</a>( <span class='pre'>outputStream</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>outputStream</span> : java.io.OutputStream<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-saveToRepo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-saveToRepo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-saveToRepo' class='name expandable'>saveToRepo</a>( <span class='pre'>saveToRepoConfig</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Saves the converted document into the repository. ...</div><div class='long'><p>Saves the converted document into the repository.</p>\n\n<pre><code>officeDocument.getSaveParams({ format: \"pdf\", parentId: \"ARCPATH:/Folder1\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveToRepoConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Object ID</p>\n</div></li></ul></div></div></div><div id='method-saveToStream' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-saveToStream' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-saveToStream' class='name expandable'>saveToStream</a>( <span class='pre'>saveConfig</span> ) : java.io.InputStream<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Writes the converted document into a stream. ...</div><div class='long'><p>Writes the converted document into a stream.</p>\n\n<pre><code>officeDocument.saveToStream({ format: \"pdf\" });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>saveConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.InputStream</span><div class='sub-desc'><p>Input stream</p>\n</div></li></ul></div></div></div><div id='method-updatePart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-updatePart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-updatePart' class='name expandable'>updatePart</a>( <span class='pre'>control, partIdFieldName, partObjId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Update document part ...</div><div class='long'><p>Update document part</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>control</span> : com.aspose.words.StructuredDocumentTag<div class='sub-desc'>\n</div></li><li><span class='pre'>partIdFieldName</span> : String<div class='sub-desc'><p>Part ID field name</p>\n</div></li><li><span class='pre'>partObjId</span> : String<div class='sub-desc'><p>Part object ID</p>\n</div></li></ul></div></div></div><div id='method-updateParts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.OfficeConverter'>sol.common.as.functions.OfficeConverter</span><br/><a href='source/lib_sol.common.as.Office.html#sol-common-as-functions-OfficeConverter-method-updateParts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.OfficeConverter-method-updateParts' class='name expandable'>updateParts</a>( <span class='pre'>params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Update document parts ...</div><div class='long'><p>Update document parts</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>partIdentifierPrefix</span> : String<div class='sub-desc'><p>Part identifier prefix, e.g. <code>sol.common.DocumentPart</code></p>\n</div></li></ul></div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true}});